<?php include 'header.php'; ?>

<!-- Page Header -->
<section class="page-header py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="page-header-title mb-4">About MaskHosting</h1>
        <p class="page-header-subtitle">Your trusted partner for privacy-first offshore hosting solutions</p>
    </div>
</section>

<!-- Mission Section -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="section-title text-left">Our Mission</h2>
                <p class="text-gray-400 text-lg mb-6 leading-relaxed">
                    At MaskHosting, we believe that privacy is a fundamental human right, not a luxury. Since our founding, we've been committed to providing hosting solutions that put your freedom and security first.
                </p>
                <p class="text-gray-400 text-lg mb-6 leading-relaxed">
                    We understand the challenges of hosting content in an increasingly regulated digital landscape. That's why we've built our infrastructure in offshore locations with strong privacy protections, ensuring your data remains yours and yours alone.
                </p>
                <p class="text-gray-400 text-lg leading-relaxed">
                    Our DMCA-ignored hosting policies mean you can focus on your business without worrying about frivolous takedown requests or censorship. We're here to ensure your voice is heard, no matter what.
                </p>
            </div>
            <div class="mission-visual">
                <div class="mission-card">
                    <div class="mission-icon">
                        <i class="fas fa-bullseye"></i>
                    </div>
                    <h3>Privacy First</h3>
                    <p>Your data is encrypted, protected, and never shared</p>
                </div>
                <div class="mission-card">
                    <div class="mission-icon">
                        <i class="fas fa-shield-check"></i>
                    </div>
                    <h3>DMCA Ignored</h3>
                    <p>Host freely without fear of unjust takedowns</p>
                </div>
                <div class="mission-card">
                    <div class="mission-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Customer Focused</h3>
                    <p>24/7 support from real humans who care</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Choose Us Section -->
<section class="py-20 bg-gradient-to-b from-transparent to-blue-900/10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Why Choose MaskHosting?</h2>
            <p class="section-description">We're not just another hosting provider. We're your privacy partners.</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="value-card">
                <div class="value-number">01</div>
                <h3 class="value-title">True Offshore Hosting</h3>
                <p class="value-text">Our servers are located in jurisdictions with the strongest privacy laws, far from invasive government regulations.</p>
            </div>
            
            <div class="value-card">
                <div class="value-number">02</div>
                <h3 class="value-title">No Logs Policy</h3>
                <p class="value-text">We don't track, log, or monitor your activities. What you do on our servers is your business, not ours.</p>
            </div>
            
            <div class="value-card">
                <div class="value-number">03</div>
                <h3 class="value-title">Instant Setup</h3>
                <p class="value-text">Get your hosting account activated within minutes. No lengthy verification processes or delays.</p>
            </div>
            
            <div class="value-card">
                <div class="value-number">04</div>
                <h3 class="value-title">Unbeatable Support</h3>
                <p class="value-text">Our expert team is available 24/7/365 to assist you with any technical or billing questions.</p>
            </div>
        </div>
    </div>
</section>

<!-- Our Story Section -->
<section class="py-20">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="story-container">
            <h2 class="section-title text-center mb-12">Our Story</h2>
            
            <div class="timeline">
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3 class="timeline-year">2018</h3>
                        <h4 class="timeline-title">The Beginning</h4>
                        <p class="timeline-text">MaskHosting was founded by a group of privacy advocates who were frustrated with the lack of truly private hosting options in the market.</p>
                    </div>
                </div>
                
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3 class="timeline-year">2020</h3>
                        <h4 class="timeline-title">Expansion</h4>
                        <p class="timeline-text">We expanded our infrastructure to multiple offshore locations, providing even more privacy and redundancy for our customers.</p>
                    </div>
                </div>
                
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3 class="timeline-year">2022</h3>
                        <h4 class="timeline-title">Innovation</h4>
                        <p class="timeline-text">Launched our VPS and cloud hosting platforms, bringing enterprise-grade privacy solutions to businesses of all sizes.</p>
                    </div>
                </div>
                
                <div class="timeline-item">
                    <div class="timeline-marker"></div>
                    <div class="timeline-content">
                        <h3 class="timeline-year">2024</h3>
                        <h4 class="timeline-title">Today</h4>
                        <p class="timeline-text">Serving thousands of customers worldwide, MaskHosting continues to be the go-to choice for privacy-conscious individuals and businesses.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Team Section -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Our Commitment to You</h2>
            <p class="section-description">These are the principles that guide everything we do</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="commitment-card">
                <i class="fas fa-hand-holding-heart text-5xl text-primary mb-4"></i>
                <h3 class="text-2xl font-bold mb-3">Transparency</h3>
                <p class="text-gray-400">No hidden fees, no surprises. What you see is what you get with clear, straightforward pricing and policies.</p>
            </div>
            
            <div class="commitment-card">
                <i class="fas fa-clock text-5xl text-primary mb-4"></i>
                <h3 class="text-2xl font-bold mb-3">Reliability</h3>
                <p class="text-gray-400">99.9% uptime guarantee backed by redundant infrastructure and enterprise-grade hardware.</p>
            </div>
            
            <div class="commitment-card">
                <i class="fas fa-rocket text-5xl text-primary mb-4"></i>
                <h3 class="text-2xl font-bold mb-3">Innovation</h3>
                <p class="text-gray-400">We're constantly evolving our services to stay ahead of threats and provide cutting-edge privacy solutions.</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">Ready to Experience the Difference?</h2>
        <p class="text-xl text-gray-400 mb-10">Join thousands of satisfied customers who trust MaskHosting for their offshore hosting needs.</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="pricing.php" class="btn-primary text-lg px-10 py-4">
                <i class="fas fa-rocket mr-2"></i>Get Started
            </a>
            <a href="contact.php" class="btn-secondary text-lg px-10 py-4">
                <i class="fas fa-phone mr-2"></i>Contact Us
            </a>
        </div>
    </div>
</section>

<style>
    .page-header {
        background: linear-gradient(135deg, rgba(0, 255, 136, 0.1), rgba(0, 204, 255, 0.1));
        border-bottom: 1px solid rgba(0, 255, 136, 0.3);
    }
    
    .page-header-title {
        font-family: 'Orbitron', monospace;
        font-size: 3.5rem;
        font-weight: 900;
        background: linear-gradient(135deg, white, var(--primary));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .page-header-subtitle {
        font-size: 1.3rem;
        color: #9ca3af;
        max-width: 700px;
        margin: 0 auto;
    }
    
    .mission-visual {
        display: grid;
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .mission-card {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        padding: 2rem;
        transition: all 0.3s ease;
    }
    
    .mission-card:hover {
        transform: translateX(10px);
        border-color: var(--primary);
        box-shadow: 0 10px 30px rgba(0, 255, 136, 0.2);
    }
    
    .mission-icon {
        width: 60px;
        height: 60px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.8rem;
        color: var(--primary);
        margin-bottom: 1rem;
    }
    
    .mission-card h3 {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    
    .mission-card p {
        color: #9ca3af;
    }
    
    .value-card {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 16px;
        padding: 2rem;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .value-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, var(--primary), transparent);
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.3s ease;
    }
    
    .value-card:hover::before {
        transform: scaleX(1);
    }
    
    .value-card:hover {
        transform: translateY(-5px);
        border-color: var(--primary);
        box-shadow: 0 15px 35px rgba(0, 255, 136, 0.2);
    }
    
    .value-number {
        font-family: 'Orbitron', monospace;
        font-size: 3rem;
        font-weight: 900;
        color: rgba(0, 255, 136, 0.2);
        margin-bottom: 1rem;
    }
    
    .value-title {
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 1rem;
        color: white;
    }
    
    .value-text {
        color: #9ca3af;
        line-height: 1.7;
    }
    
    .story-container {
        background: rgba(15, 22, 41, 0.4);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 3rem;
    }
    
    .timeline {
        position: relative;
        padding: 2rem 0;
    }
    
    .timeline::before {
        content: '';
        position: absolute;
        left: 30px;
        top: 0;
        bottom: 0;
        width: 2px;
        background: linear-gradient(180deg, var(--primary), rgba(0, 255, 136, 0.2));
    }
    
    .timeline-item {
        position: relative;
        padding-left: 80px;
        margin-bottom: 3rem;
    }
    
    .timeline-marker {
        position: absolute;
        left: 20px;
        top: 0;
        width: 20px;
        height: 20px;
        background: var(--primary);
        border: 4px solid var(--dark);
        border-radius: 50%;
        box-shadow: 0 0 20px rgba(0, 255, 136, 0.5);
    }
    
    .timeline-year {
        font-family: 'Orbitron', monospace;
        font-size: 1.5rem;
        font-weight: 900;
        color: var(--primary);
        margin-bottom: 0.5rem;
    }
    
    .timeline-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.75rem;
    }
    
    .timeline-text {
        color: #9ca3af;
        line-height: 1.7;
    }
    
    .commitment-card {
        text-align: center;
        padding: 2rem;
        transition: all 0.3s ease;
    }
    
    .commitment-card:hover {
        transform: translateY(-10px);
    }
    
    .commitment-card i {
        transition: all 0.3s ease;
    }
    
    .commitment-card:hover i {
        transform: scale(1.2);
    }
    
    @media (max-width: 768px) {
        .page-header-title {
            font-size: 2.5rem;
        }
        
        .timeline::before {
            left: 10px;
        }
        
        .timeline-marker {
            left: 0;
        }
        
        .timeline-item {
            padding-left: 50px;
        }
    }
</style>

<?php include 'footer.php'; ?>
