<?php include 'header.php'; ?>

<!-- Hero Section -->
<section class="hero-section relative py-20 md:py-32">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <div class="inline-block mb-4">
                <span class="badge">
                    <i class="fas fa-globe mr-2"></i>Private Domain Registration
                </span>
            </div>
            <h1 class="hero-title mb-6">Register Your Domain</h1>
            <p class="hero-description max-w-3xl mx-auto mb-10">
                Secure your online presence with our private domain registration. Complete WHOIS protection, instant activation, and competitive pricing on all popular extensions.
            </p>
        </div>
        
        <!-- Domain Search -->
        <div class="max-w-3xl mx-auto">
            <form id="domainSearchForm" class="domain-search-hero">
                <div class="search-container-hero">
                    <input type="text" id="domainInput" placeholder="Search for your perfect domain..." class="domain-input-hero" required>
                    <button type="submit" class="search-button-hero">
                        <i class="fas fa-search mr-2"></i>Search
                    </button>
                </div>
            </form>
            
            <div class="popular-searches mt-6 text-center">
                <span class="text-sm text-gray-500 mr-3">Popular:</span>
                <button onclick="searchDomain('yourname.com')" class="popular-tag">.com</button>
                <button onclick="searchDomain('yourname.net')" class="popular-tag">.net</button>
                <button onclick="searchDomain('yourname.io')" class="popular-tag">.io</button>
                <button onclick="searchDomain('yourname.app')" class="popular-tag">.app</button>
            </div>
        </div>
    </div>
</section>

<!-- Domain Pricing -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Domain Pricing</h2>
            <p class="section-description">Transparent pricing with no hidden fees</p>
        </div>
        
        <div class="domain-pricing-grid">
            <div class="domain-price-card">
                <div class="domain-ext-large">.com</div>
                <div class="domain-price-main">$9.99<span>/year</span></div>
                <p class="text-gray-400 mb-4">Most popular extension</p>
                <ul class="domain-features">
                    <li><i class="fas fa-check"></i>Free WHOIS protection</li>
                    <li><i class="fas fa-check"></i>Easy DNS management</li>
                    <li><i class="fas fa-check"></i>Email forwarding</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-secondary w-full text-center mt-4">Register Now</a>
            </div>
            
            <div class="domain-price-card">
                <div class="domain-ext-large">.net</div>
                <div class="domain-price-main">$11.99<span>/year</span></div>
                <p class="text-gray-400 mb-4">Great alternative to .com</p>
                <ul class="domain-features">
                    <li><i class="fas fa-check"></i>Free WHOIS protection</li>
                    <li><i class="fas fa-check"></i>Easy DNS management</li>
                    <li><i class="fas fa-check"></i>Email forwarding</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-secondary w-full text-center mt-4">Register Now</a>
            </div>
            
            <div class="domain-price-card featured">
                <div class="featured-ribbon">Best Value</div>
                <div class="domain-ext-large">.org</div>
                <div class="domain-price-main">$10.99<span>/year</span></div>
                <p class="text-gray-400 mb-4">Perfect for organizations</p>
                <ul class="domain-features">
                    <li><i class="fas fa-check"></i>Free WHOIS protection</li>
                    <li><i class="fas fa-check"></i>Easy DNS management</li>
                    <li><i class="fas fa-check"></i>Email forwarding</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-primary w-full text-center mt-4">Register Now</a>
            </div>
            
            <div class="domain-price-card">
                <div class="domain-ext-large">.io</div>
                <div class="domain-price-main">$39.99<span>/year</span></div>
                <p class="text-gray-400 mb-4">Tech startups favorite</p>
                <ul class="domain-features">
                    <li><i class="fas fa-check"></i>Free WHOIS protection</li>
                    <li><i class="fas fa-check"></i>Easy DNS management</li>
                    <li><i class="fas fa-check"></i>Email forwarding</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-secondary w-full text-center mt-4">Register Now</a>
            </div>
        </div>
    </div>
</section>

<!-- All TLDs -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="section-title">All Available Extensions</h2>
            <p class="section-description">Over 500 domain extensions to choose from</p>
        </div>
        
        <div class="tld-table-container">
            <table class="tld-table">
                <thead>
                    <tr>
                        <th>Extension</th>
                        <th>Register</th>
                        <th>Transfer</th>
                        <th>Renew</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong>.com</strong></td>
                        <td>$9.99/yr</td>
                        <td>$9.99/yr</td>
                        <td>$11.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.net</strong></td>
                        <td>$11.99/yr</td>
                        <td>$11.99/yr</td>
                        <td>$13.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.org</strong></td>
                        <td>$10.99/yr</td>
                        <td>$10.99/yr</td>
                        <td>$12.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.io</strong></td>
                        <td>$39.99/yr</td>
                        <td>$39.99/yr</td>
                        <td>$39.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.app</strong></td>
                        <td>$14.99/yr</td>
                        <td>$14.99/yr</td>
                        <td>$16.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.dev</strong></td>
                        <td>$12.99/yr</td>
                        <td>$12.99/yr</td>
                        <td>$14.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.co</strong></td>
                        <td>$24.99/yr</td>
                        <td>$24.99/yr</td>
                        <td>$26.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                    <tr>
                        <td><strong>.xyz</strong></td>
                        <td>$11.99/yr</td>
                        <td>$11.99/yr</td>
                        <td>$13.99/yr</td>
                        <td><a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register" class="btn-sm">Register</a></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</section>

<!-- Features -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Domain Features</h2>
            <p class="section-description">Everything you need for complete domain management</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-user-secret"></i>
                </div>
                <h3 class="feature-title">WHOIS Privacy</h3>
                <p class="feature-text">Free WHOIS protection keeps your personal information private and spam-free.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-lock"></i>
                </div>
                <h3 class="feature-title">Domain Lock</h3>
                <p class="feature-text">Protect your domain from unauthorized transfers with domain locking.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-network-wired"></i>
                </div>
                <h3 class="feature-title">DNS Management</h3>
                <p class="feature-text">Full control over DNS records with an easy-to-use control panel.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <h3 class="feature-title">Email Forwarding</h3>
                <p class="feature-text">Forward unlimited email addresses to your existing email account.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-sync-alt"></i>
                </div>
                <h3 class="feature-title">Auto-Renewal</h3>
                <p class="feature-text">Never lose your domain with automatic renewal options.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-exchange-alt"></i>
                </div>
                <h3 class="feature-title">Easy Transfers</h3>
                <p class="feature-text">Transfer your domains to us easily with no downtime.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-bell"></i>
                </div>
                <h3 class="feature-title">Expiry Alerts</h3>
                <p class="feature-text">Get notified before your domain expires so you never miss renewal.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h3 class="feature-title">24/7 Support</h3>
                <p class="feature-text">Expert domain support available whenever you need assistance.</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="py-20 bg-gradient-to-b from-transparent to-blue-900/10">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">Ready to Claim Your Domain?</h2>
        <p class="text-xl text-gray-400 mb-10">Search now and secure your perfect domain before someone else does.</p>
        <a href="#domainSearchForm" class="btn-primary text-lg px-10 py-4">
            <i class="fas fa-search mr-2"></i>Search Domains
        </a>
    </div>
</section>

<style>
    .domain-search-hero {
        width: 100%;
    }
    
    .search-container-hero {
        display: flex;
        gap: 1rem;
        background: rgba(15, 22, 41, 0.8);
        border: 2px solid rgba(0, 255, 136, 0.3);
        border-radius: 16px;
        padding: 0.75rem;
    }
    
    .domain-input-hero {
        flex: 1;
        background: transparent;
        border: none;
        color: white;
        font-size: 1.2rem;
        padding: 1rem 1.5rem;
        outline: none;
    }
    
    .search-button-hero {
        background: var(--primary);
        color: var(--dark);
        border: none;
        border-radius: 12px;
        padding: 1rem 3rem;
        font-weight: 700;
        font-size: 1.1rem;
        cursor: pointer;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 1px;
        white-space: nowrap;
    }
    
    .search-button-hero:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 30px rgba(0, 255, 136, 0.4);
    }
    
    .popular-tag {
        display: inline-block;
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid rgba(0, 255, 136, 0.3);
        color: var(--primary);
        padding: 6px 16px;
        border-radius: 50px;
        margin: 0 0.25rem;
        font-size: 0.9rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .popular-tag:hover {
        background: var(--primary);
        color: var(--dark);
        transform: translateY(-2px);
    }
    
    .domain-pricing-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 2rem;
        max-width: 1400px;
        margin: 0 auto;
    }
    
    .domain-price-card {
        background: rgba(15, 22, 41, 0.8);
        border: 2px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 2.5rem;
        text-align: center;
        position: relative;
        transition: all 0.3s ease;
    }
    
    .domain-price-card.featured {
        border-color: var(--primary);
        box-shadow: 0 0 40px rgba(0, 255, 136, 0.3);
    }
    
    .domain-price-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 50px rgba(0, 255, 136, 0.3);
    }
    
    .featured-ribbon {
        position: absolute;
        top: -12px;
        right: 20px;
        background: var(--primary);
        color: var(--dark);
        padding: 6px 16px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.8rem;
        text-transform: uppercase;
    }
    
    .domain-ext-large {
        font-family: 'Orbitron', monospace;
        font-size: 3rem;
        font-weight: 900;
        color: var(--primary);
        margin-bottom: 1rem;
    }
    
    .domain-price-main {
        font-size: 2.5rem;
        font-weight: 900;
        color: white;
        margin-bottom: 0.5rem;
    }
    
    .domain-price-main span {
        font-size: 1.2rem;
        color: #6b7280;
        margin-left: 0.5rem;
    }
    
    .domain-features {
        list-style: none;
        text-align: left;
        margin: 1.5rem 0;
    }
    
    .domain-features li {
        padding: 0.5rem 0;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        color: #d1d5db;
    }
    
    .domain-features i {
        color: var(--primary);
    }
    
    .tld-table-container {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 16px;
        overflow: hidden;
    }
    
    .tld-table {
        width: 100%;
        border-collapse: collapse;
    }
    
    .tld-table thead {
        background: rgba(0, 255, 136, 0.1);
    }
    
    .tld-table th {
        padding: 1.5rem;
        text-align: left;
        font-weight: 700;
        color: var(--primary);
        border-bottom: 2px solid rgba(0, 255, 136, 0.3);
    }
    
    .tld-table td {
        padding: 1.25rem 1.5rem;
        color: #d1d5db;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .tld-table tbody tr:hover {
        background: rgba(0, 255, 136, 0.05);
    }
    
    .btn-sm {
        background: var(--primary);
        color: var(--dark);
        padding: 0.5rem 1.25rem;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
        display: inline-block;
    }
    
    .btn-sm:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 255, 136, 0.3);
    }
    
    @media (max-width: 768px) {
        .search-container-hero {
            flex-direction: column;
        }
        
        .search-button-hero {
            width: 100%;
        }
        
        .tld-table {
            font-size: 0.85rem;
        }
        
        .tld-table th,
        .tld-table td {
            padding: 0.75rem;
        }
    }
</style>

<script>
    function searchDomain(domain) {
        document.getElementById('domainInput').value = domain.replace('yourname', '');
        document.getElementById('domainSearchForm').scrollIntoView({ behavior: 'smooth' });
    }
    
    document.getElementById('domainSearchForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const domain = document.getElementById('domainInput').value.trim();
        
        if (domain) {
            window.location.href = '<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register&query=' + encodeURIComponent(domain);
        }
    });
</script>

<?php include 'footer.php'; ?>
