<?php include 'header.php'; ?>

<!-- Page Header -->
<section class="page-header py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="page-header-title mb-4">Frequently Asked Questions</h1>
        <p class="page-header-subtitle">Find answers to common questions about MaskHosting services</p>
    </div>
</section>

<!-- FAQ Categories -->
<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="faq-categories">
            <button class="category-btn active" data-category="all">All Questions</button>
            <button class="category-btn" data-category="general">General</button>
            <button class="category-btn" data-category="hosting">Hosting</button>
            <button class="category-btn" data-category="domains">Domains</button>
            <button class="category-btn" data-category="billing">Billing</button>
            <button class="category-btn" data-category="technical">Technical</button>
        </div>
    </div>
</section>

<!-- FAQ Content -->
<section class="py-12">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <!-- General FAQs -->
        <div class="faq-section" data-category="general">
            <h2 class="faq-section-title">General Questions</h2>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What is offshore hosting?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Offshore hosting refers to hosting services located in countries outside your own, typically in jurisdictions with strong privacy laws and less restrictive content policies. MaskHosting operates servers in privacy-friendly locations that offer protection from DMCA takedowns and other content restrictions common in countries like the United States.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Why should I choose offshore hosting?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Offshore hosting provides several benefits: enhanced privacy protection, DMCA ignored policies, freedom from censorship, protection from local legal issues, and stronger data protection laws. It's ideal for businesses and individuals who prioritize privacy and freedom of expression.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Is offshore hosting legal?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes, offshore hosting is completely legal. It's a legitimate service used by businesses and individuals worldwide. However, you are still responsible for ensuring your content complies with local laws and our Acceptable Use Policy. We do not tolerate illegal activities such as child abuse content, terrorism, or criminal activities.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Where are your servers located?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>We operate data centers in several privacy-friendly offshore locations including the Netherlands, Romania, and Iceland. These jurisdictions offer strong privacy protections and favorable content policies. You can choose your preferred location when ordering.</p>
                </div>
            </div>
        </div>
        
        <!-- Hosting FAQs -->
        <div class="faq-section" data-category="hosting">
            <h2 class="faq-section-title">Hosting Questions</h2>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What is DMCA ignored hosting?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>DMCA ignored hosting means our servers are located in jurisdictions that don't recognize or enforce DMCA (Digital Millennium Copyright Act) takedown notices. This protects your content from frivolous copyright claims. However, we still respond to valid legal requests from local authorities in our server locations.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>How quickly will my hosting be activated?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Shared hosting accounts are typically activated within 5-15 minutes of payment confirmation. VPS and dedicated servers are usually provisioned within 1-4 hours. You'll receive an email with login details once your service is ready.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Can I upgrade my hosting plan later?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! You can upgrade your hosting plan at any time from your client area. The cost difference will be prorated, and you'll only pay for the remaining time on your current billing cycle. Upgrades are processed instantly with no downtime.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Do you provide website migration services?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! We offer free website migration for our Business shared hosting plan and all VPS/Cloud plans. Our expert team will transfer your websites, databases, and email accounts from your current host with zero downtime. For other plans, migrations are available for a small fee.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What is your uptime guarantee?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>We guarantee 99.9% uptime for all hosting services. Our redundant infrastructure, enterprise hardware, and 24/7 monitoring ensure your websites stay online. If we fail to meet this guarantee, you're eligible for service credits.</p>
                </div>
            </div>
        </div>
        
        <!-- Domain FAQs -->
        <div class="faq-section" data-category="domains">
            <h2 class="faq-section-title">Domain Questions</h2>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Do you offer free domain registration?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! We include a free domain registration for one year with our Professional and Business shared hosting plans. You can choose from popular extensions like .com, .net, .org, and many others.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Is WHOIS privacy protection included?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Absolutely! We include free WHOIS privacy protection with all domain registrations. This keeps your personal information (name, address, email, phone) private and protected from spammers and identity thieves.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Can I transfer my existing domain to MaskHosting?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! Domain transfers are easy and include no downtime. You'll need to unlock your domain at your current registrar and obtain an authorization/EPP code. The transfer process typically completes within 5-7 days, and you get a free year added to your registration.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What if my desired domain is already taken?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>If your desired domain is unavailable, try different extensions (.net, .org, .io, etc.) or variations of your name. Our domain search tool will suggest available alternatives. You can also use our domain backorder service to be notified if the domain becomes available.</p>
                </div>
            </div>
        </div>
        
        <!-- Billing FAQs -->
        <div class="faq-section" data-category="billing">
            <h2 class="faq-section-title">Billing & Payments</h2>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What payment methods do you accept?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>We accept major credit cards (Visa, Mastercard, American Express), PayPal, and cryptocurrency (Bitcoin, Ethereum, Litecoin) for maximum privacy and convenience. All payments are processed securely.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Do you offer a money-back guarantee?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! We offer a 30-day money-back guarantee on all shared hosting plans. If you're not completely satisfied within the first 30 days, we'll provide a full refund, no questions asked. VPS and dedicated servers have a 7-day money-back guarantee.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Are there any hidden fees?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>No! We believe in transparent pricing. The price you see is the price you pay. There are no setup fees, hidden charges, or surprise costs. Domain privacy protection and SSL certificates are included free.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Can I cancel my service anytime?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes, you can cancel your service at any time from your client area. Monthly plans can be cancelled without penalty. Annual plans can be cancelled, but refunds are subject to our money-back guarantee terms.</p>
                </div>
            </div>
        </div>
        
        <!-- Technical FAQs -->
        <div class="faq-section" data-category="technical">
            <h2 class="faq-section-title">Technical Questions</h2>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What control panel do you provide?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>All shared hosting plans include cPanel, the industry-standard control panel. It provides an intuitive interface for managing your websites, emails, databases, and more. VPS customers can choose cPanel/WHM or manage their server via command line.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Do you provide SSL certificates?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! Free Let's Encrypt SSL certificates are included with all hosting plans. You can install unlimited SSL certificates for all your domains with just one click through cPanel. Premium SSL certificates are also available for purchase.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>What programming languages and databases do you support?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>We support PHP (multiple versions), Python, Node.js, Ruby, and more. For databases, we support MySQL, PostgreSQL, and MongoDB. VPS customers have full control to install any software they need.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Do you provide DDoS protection?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! All our hosting plans include enterprise-grade DDoS protection. Our network can mitigate attacks up to 100Gbps, ensuring your websites stay online even during attacks. Advanced DDoS protection is available for high-risk applications.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>How often are backups performed?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Shared hosting plans include daily automated backups retained for 30 days. Business plans get hourly backups. VPS customers can configure their own backup schedule or use our managed backup service. All backups can be restored instantly from your control panel.</p>
                </div>
            </div>
        </div>
        
    </div>
</section>

<!-- Still Have Questions -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-bold mb-4">Still Have Questions?</h2>
        <p class="text-xl text-gray-400 mb-8">Our support team is available 24/7 to help you with any questions.</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="contact.php" class="btn-primary text-lg px-10 py-4">
                <i class="fas fa-comments mr-2"></i>Contact Support
            </a>
            <a href="<?php echo CLIENT_AREA_URL; ?>/submitticket.php" class="btn-secondary text-lg px-10 py-4">
                <i class="fas fa-ticket-alt mr-2"></i>Submit Ticket
            </a>
        </div>
    </div>
</section>

<style>
    .faq-categories {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 1rem;
        margin-bottom: 2rem;
    }
    
    .category-btn {
        background: rgba(15, 22, 41, 0.6);
        border: 2px solid rgba(0, 255, 136, 0.2);
        color: #d1d5db;
        padding: 0.75rem 1.5rem;
        border-radius: 50px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .category-btn:hover,
    .category-btn.active {
        background: var(--primary);
        color: var(--dark);
        border-color: var(--primary);
        transform: translateY(-2px);
    }
    
    .faq-section {
        margin-bottom: 3rem;
    }
    
    .faq-section-title {
        font-size: 2rem;
        font-weight: 700;
        color: var(--primary);
        margin-bottom: 2rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid rgba(0, 255, 136, 0.3);
    }
    
    .faq-item {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        overflow: hidden;
        margin-bottom: 1rem;
        transition: all 0.3s ease;
    }
    
    .faq-item:hover {
        border-color: var(--primary);
        box-shadow: 0 5px 20px rgba(0, 255, 136, 0.1);
    }
    
    .faq-question {
        width: 100%;
        padding: 1.5rem;
        background: transparent;
        border: none;
        color: white;
        font-size: 1.1rem;
        font-weight: 600;
        text-align: left;
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .faq-question:hover {
        color: var(--primary);
    }
    
    .faq-question i {
        transition: transform 0.3s ease;
        color: var(--primary);
    }
    
    .faq-item.active .faq-question i {
        transform: rotate(180deg);
    }
    
    .faq-answer {
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }
    
    .faq-item.active .faq-answer {
        max-height: 1000px;
    }
    
    .faq-answer p {
        padding: 0 1.5rem 1.5rem;
        color: #9ca3af;
        line-height: 1.8;
        font-size: 1rem;
    }
</style>

<script>
    // FAQ accordion
    document.querySelectorAll('.faq-question').forEach(question => {
        question.addEventListener('click', () => {
            const item = question.parentElement;
            const isActive = item.classList.contains('active');
            
            // Close all other items in the same section
            const section = item.closest('.faq-section');
            section.querySelectorAll('.faq-item').forEach(i => i.classList.remove('active'));
            
            if (!isActive) {
                item.classList.add('active');
            }
        });
    });
    
    // Category filtering
    const categoryBtns = document.querySelectorAll('.category-btn');
    const faqSections = document.querySelectorAll('.faq-section');
    
    categoryBtns.forEach(btn => {
        btn.addEventListener('click', () => {
            const category = btn.dataset.category;
            
            // Update active button
            categoryBtns.forEach(b => b.classList.remove('active'));
            btn.classList.add('active');
            
            // Show/hide sections
            faqSections.forEach(section => {
                if (category === 'all' || section.dataset.category === category) {
                    section.style.display = 'block';
                } else {
                    section.style.display = 'none';
                }
            });
        });
    });
</script>

<?php include 'footer.php'; ?>
