    </div>
    <!-- Page Content Ends Here -->
    
    <!-- Footer -->
    <footer class="relative mt-20 border-t border-gray-800" style="background: linear-gradient(180deg, #050810 0%, #0a0e27 100%);">
        <!-- Main Footer -->
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
                <!-- Brand Column -->
                <div>
                    <div class="logo mb-4">
                        <i class="fas fa-shield-halved mr-2"></i>MaskHosting
                    </div>
                    <p class="text-gray-400 mb-6 leading-relaxed">
                        Your trusted partner for offshore DMCA ignored hosting solutions. We prioritize your privacy, security, and freedom.
                    </p>
                    <div class="flex space-x-4">
                        <a href="<?php echo TWITTER_URL; ?>" class="social-icon" aria-label="Twitter">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="<?php echo FACEBOOK_URL; ?>" class="social-icon" aria-label="Facebook">
                            <i class="fab fa-facebook"></i>
                        </a>
                        <a href="<?php echo TELEGRAM_URL; ?>" class="social-icon" aria-label="Telegram">
                            <i class="fab fa-telegram"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Services Column -->
                <div>
                    <h3 class="footer-heading mb-6">Our Services</h3>
                    <ul class="space-y-3">
                        <li><a href="shared-hosting.php" class="footer-link">Offshore Shared Hosting</a></li>
                        <li><a href="vps-hosting.php" class="footer-link">VPS Hosting</a></li>
                        <li><a href="vps-hosting.php" class="footer-link">Cloud Hosting</a></li>
                        <li><a href="domains.php" class="footer-link">Domain Registration</a></li>
                        <li><a href="features.php" class="footer-link">Features</a></li>
                        <li><a href="pricing.php" class="footer-link">Pricing Plans</a></li>
                    </ul>
                </div>
                
                <!-- Company Column -->
                <div>
                    <h3 class="footer-heading mb-6">Company</h3>
                    <ul class="space-y-3">
                        <li><a href="about.php" class="footer-link">About Us</a></li>
                        <li><a href="contact.php" class="footer-link">Contact Support</a></li>
                        <li><a href="faq.php" class="footer-link">FAQ</a></li>
                        <li><a href="terms.php" class="footer-link">Terms of Service</a></li>
                        <li><a href="privacy.php" class="footer-link">Privacy Policy</a></li>
                        <li><a href="acceptable-use.php" class="footer-link">Acceptable Use Policy</a></li>
                    </ul>
                </div>
                
                <!-- Contact Column -->
                <div>
                    <h3 class="footer-heading mb-6">Get In Touch</h3>
                    <ul class="space-y-4">
                        <li class="flex items-start">
                            <i class="fas fa-envelope text-primary mt-1 mr-3"></i>
                            <div>
                                <p class="text-sm text-gray-500">Sales</p>
                                <a href="mailto:<?php echo SALES_EMAIL; ?>" class="footer-link"><?php echo SALES_EMAIL; ?></a>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-headset text-primary mt-1 mr-3"></i>
                            <div>
                                <p class="text-sm text-gray-500">Support</p>
                                <a href="mailto:<?php echo CONTACT_EMAIL; ?>" class="footer-link"><?php echo CONTACT_EMAIL; ?></a>
                            </div>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-phone text-primary mt-1 mr-3"></i>
                            <div>
                                <p class="text-sm text-gray-500">Phone</p>
                                <a href="tel:<?php echo str_replace([' ', '(', ')', '-'], '', CONTACT_PHONE); ?>" class="footer-link"><?php echo CONTACT_PHONE; ?></a>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Trust Badges -->
            <div class="mt-16 pt-12 border-t border-gray-800">
                <div class="grid grid-cols-2 md:grid-cols-4 gap-8 items-center text-center">
                    <div class="trust-badge">
                        <i class="fas fa-shield-check text-4xl text-primary mb-3"></i>
                        <p class="text-sm font-semibold">99.9% Uptime</p>
                        <p class="text-xs text-gray-500">Guaranteed</p>
                    </div>
                    <div class="trust-badge">
                        <i class="fas fa-lock text-4xl text-primary mb-3"></i>
                        <p class="text-sm font-semibold">SSL Included</p>
                        <p class="text-xs text-gray-500">Free Forever</p>
                    </div>
                    <div class="trust-badge">
                        <i class="fas fa-headphones text-4xl text-primary mb-3"></i>
                        <p class="text-sm font-semibold">24/7 Support</p>
                        <p class="text-xs text-gray-500">Always Available</p>
                    </div>
                    <div class="trust-badge">
                        <i class="fas fa-user-shield text-4xl text-primary mb-3"></i>
                        <p class="text-sm font-semibold">Privacy First</p>
                        <p class="text-xs text-gray-500">DMCA Ignored</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Bottom Footer -->
        <div class="border-t border-gray-800">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <p class="text-gray-500 text-sm mb-4 md:mb-0">
                        &copy; <?php echo date('Y'); ?> MaskHosting. All rights reserved. Offshore hosting with complete privacy.
                    </p>
                    <div class="flex items-center space-x-6">
                        <img src="https://img.icons8.com/color/48/000000/visa.png" alt="Visa" class="h-8 opacity-70 hover:opacity-100 transition-opacity">
                        <img src="https://img.icons8.com/color/48/000000/mastercard.png" alt="Mastercard" class="h-8 opacity-70 hover:opacity-100 transition-opacity">
                        <img src="https://img.icons8.com/color/48/000000/paypal.png" alt="PayPal" class="h-8 opacity-70 hover:opacity-100 transition-opacity">
                        <img src="https://img.icons8.com/color/48/000000/bitcoin.png" alt="Bitcoin" class="h-8 opacity-70 hover:opacity-100 transition-opacity">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Scroll to Top Button -->
        <button id="scrollTop" class="scroll-top" aria-label="Scroll to top">
            <i class="fas fa-arrow-up"></i>
        </button>
    </footer>
    
    <style>
        .footer-heading {
            font-family: 'Orbitron', monospace;
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--primary);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .footer-link {
            color: #9ca3af;
            transition: all 0.3s ease;
            display: inline-block;
            position: relative;
        }
        
        .footer-link::before {
            content: '';
            position: absolute;
            left: 0;
            bottom: -2px;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: width 0.3s ease;
        }
        
        .footer-link:hover {
            color: var(--primary);
            transform: translateX(5px);
        }
        
        .footer-link:hover::before {
            width: 100%;
        }
        
        .social-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(0, 255, 136, 0.1);
            border: 2px solid rgba(0, 255, 136, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            transition: all 0.3s ease;
        }
        
        .social-icon:hover {
            background: var(--primary);
            color: var(--dark);
            transform: translateY(-3px) scale(1.1);
            box-shadow: 0 10px 20px rgba(0, 255, 136, 0.3);
        }
        
        .trust-badge {
            transition: all 0.3s ease;
            padding: 1rem;
            border-radius: 10px;
        }
        
        .trust-badge:hover {
            background: rgba(0, 255, 136, 0.05);
            transform: translateY(-5px);
        }
        
        .trust-badge i {
            transition: all 0.3s ease;
        }
        
        .trust-badge:hover i {
            transform: scale(1.2);
        }
        
        .scroll-top {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 50px;
            height: 50px;
            background: var(--primary);
            color: var(--dark);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 999;
            border: none;
            box-shadow: 0 5px 20px rgba(0, 255, 136, 0.3);
        }
        
        .scroll-top.visible {
            opacity: 1;
            visibility: visible;
        }
        
        .scroll-top:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 255, 136, 0.5);
        }
    </style>
    
    <script>
        // Scroll to top functionality
        const scrollTopBtn = document.getElementById('scrollTop');
        
        window.addEventListener('scroll', () => {
            if (window.scrollY > 300) {
                scrollTopBtn.classList.add('visible');
            } else {
                scrollTopBtn.classList.remove('visible');
            }
        });
        
        scrollTopBtn.addEventListener('click', () => {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>
</body>
</html>
