<?php require_once 'config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo getPageTitle(); ?></title>
    <meta name="description" content="<?php echo getMetaDescription(); ?>">
    <meta name="keywords" content="offshore hosting, DMCA ignored hosting, privacy hosting, VPS hosting, cloud hosting, domain registration, anonymous hosting">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts - Unique Typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Outfit:wght@300;400;500;600;700;800&family=Orbitron:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <style>
        :root {
            --primary: #00ff88;
            --primary-dark: #00cc6a;
            --secondary: #0a0e27;
            --accent: #ff00ff;
            --dark: #050810;
            --dark-light: #0f1629;
            --text-primary: #ffffff;
            --text-secondary: #a0aec0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Outfit', sans-serif;
            background: var(--dark);
            color: var(--text-primary);
            overflow-x: hidden;
        }
        
        /* Animated Background */
        .cyber-grid {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            opacity: 0.03;
            background-image: 
                linear-gradient(var(--primary) 1px, transparent 1px),
                linear-gradient(90deg, var(--primary) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: gridMove 20s linear infinite;
        }
        
        @keyframes gridMove {
            0% { transform: translate(0, 0); }
            100% { transform: translate(50px, 50px); }
        }
        
        /* Gradient Orbs */
        .orb {
            position: fixed;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.15;
            z-index: -1;
            animation: float 20s ease-in-out infinite;
        }
        
        .orb-1 {
            width: 500px;
            height: 500px;
            background: var(--primary);
            top: -200px;
            right: -200px;
        }
        
        .orb-2 {
            width: 400px;
            height: 400px;
            background: var(--accent);
            bottom: -150px;
            left: -150px;
            animation-delay: -5s;
        }
        
        @keyframes float {
            0%, 100% { transform: translate(0, 0) scale(1); }
            33% { transform: translate(30px, -30px) scale(1.1); }
            66% { transform: translate(-20px, 20px) scale(0.9); }
        }
        
        /* Header Styles */
        header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            z-index: 1000;
            backdrop-filter: blur(20px);
            background: rgba(5, 8, 16, 0.8);
            border-bottom: 1px solid rgba(0, 255, 136, 0.1);
            transition: all 0.3s ease;
        }
        
        header.scrolled {
            background: rgba(5, 8, 16, 0.95);
            border-bottom-color: rgba(0, 255, 136, 0.3);
            box-shadow: 0 10px 40px rgba(0, 255, 136, 0.1);
        }
        
        .logo {
            font-family: 'Orbitron', monospace;
            font-size: 1.8rem;
            font-weight: 900;
            background: linear-gradient(135deg, var(--primary), #00ccff);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: 2px;
            text-transform: uppercase;
            position: relative;
            display: inline-block;
        }
        
        .logo::before {
            content: '';
            position: absolute;
            top: -5px;
            left: -5px;
            right: -5px;
            bottom: -5px;
            background: linear-gradient(135deg, var(--primary), #00ccff);
            filter: blur(15px);
            opacity: 0;
            z-index: -1;
            transition: opacity 0.3s ease;
        }
        
        .logo:hover::before {
            opacity: 0.3;
        }
        
        /* Navigation */
        nav a {
            position: relative;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        nav a::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: width 0.3s ease;
        }
        
        nav a:hover::after,
        nav a.active::after {
            width: 100%;
        }
        
        nav a:hover {
            color: var(--primary);
        }
        
        /* Buttons */
        .btn-primary {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: var(--dark);
            padding: 12px 28px;
            border-radius: 8px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 0.9rem;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
            border: 2px solid var(--primary);
        }
        
        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.5s ease;
        }
        
        .btn-primary:hover::before {
            left: 100%;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0, 255, 136, 0.4);
        }
        
        .btn-secondary {
            background: transparent;
            color: var(--primary);
            padding: 12px 28px;
            border-radius: 8px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 0.9rem;
            border: 2px solid var(--primary);
            transition: all 0.3s ease;
        }
        
        .btn-secondary:hover {
            background: var(--primary);
            color: var(--dark);
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0, 255, 136, 0.3);
        }
        
        /* Mobile Menu */
        .mobile-menu {
            display: none;
            position: fixed;
            top: 80px;
            left: 0;
            width: 100%;
            height: calc(100vh - 80px);
            background: rgba(5, 8, 16, 0.98);
            backdrop-filter: blur(20px);
            padding: 2rem;
            transform: translateX(-100%);
            transition: transform 0.3s ease;
        }
        
        .mobile-menu.active {
            display: block;
            transform: translateX(0);
        }
        
        .mobile-menu a {
            display: block;
            padding: 1rem 0;
            font-size: 1.2rem;
            font-weight: 600;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .mobile-menu a:hover {
            color: var(--primary);
            padding-left: 1rem;
        }
        
        /* Hamburger Menu */
        .hamburger {
            display: none;
            flex-direction: column;
            cursor: pointer;
            gap: 5px;
        }
        
        .hamburger span {
            width: 25px;
            height: 3px;
            background: var(--primary);
            border-radius: 3px;
            transition: all 0.3s ease;
        }
        
        .hamburger.active span:nth-child(1) {
            transform: rotate(45deg) translate(8px, 8px);
        }
        
        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }
        
        .hamburger.active span:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -7px);
        }
        
        @media (max-width: 768px) {
            .desktop-nav {
                display: none;
            }
            
            .hamburger {
                display: flex;
            }
        }
        
        /* Page Content Margin */
        .page-content {
            margin-top: 80px;
        }
    </style>
</head>
<body>
    <!-- Background Effects -->
    <div class="cyber-grid"></div>
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>
    
    <!-- Header -->
    <header id="header">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-20">
                <!-- Logo -->
                <a href="home.php" class="logo">
                    <i class="fas fa-shield-halved mr-2"></i>MaskHosting
                </a>
                
                <!-- Desktop Navigation -->
                <nav class="desktop-nav hidden md:flex items-center space-x-8">
                    <a href="home.php" class="<?php echo getCurrentPage() == 'home' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">Home</a>
                    <a href="about.php" class="<?php echo getCurrentPage() == 'about' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">About</a>
                    <a href="shared-hosting.php" class="<?php echo getCurrentPage() == 'shared-hosting' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">Shared Hosting</a>
                    <a href="vps-hosting.php" class="<?php echo getCurrentPage() == 'vps-hosting' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">VPS & Cloud</a>
                    <a href="domains.php" class="<?php echo getCurrentPage() == 'domains' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">Domains</a>
                    <a href="pricing.php" class="<?php echo getCurrentPage() == 'pricing' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">Pricing</a>
                    <a href="contact.php" class="<?php echo getCurrentPage() == 'contact' ? 'active text-primary' : 'text-gray-300 hover:text-primary'; ?>">Contact</a>
                </nav>
                
                <!-- CTA Button -->
                <div class="hidden md:block">
                    <a href="<?php echo CLIENT_AREA_URL; ?>" class="btn-primary">Client Area</a>
                </div>
                
                <!-- Mobile Hamburger -->
                <div class="hamburger md:hidden" id="hamburger">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Mobile Menu -->
    <div class="mobile-menu" id="mobileMenu">
        <a href="home.php">Home</a>
        <a href="about.php">About</a>
        <a href="shared-hosting.php">Shared Hosting</a>
        <a href="vps-hosting.php">VPS & Cloud</a>
        <a href="domains.php">Domains</a>
        <a href="pricing.php">Pricing</a>
        <a href="contact.php">Contact</a>
        <div class="mt-6">
            <a href="<?php echo CLIENT_AREA_URL; ?>" class="btn-primary inline-block text-center w-full">Client Area</a>
        </div>
    </div>
    
    <script>
        // Header scroll effect
        window.addEventListener('scroll', () => {
            const header = document.getElementById('header');
            if (window.scrollY > 50) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });
        
        // Mobile menu toggle
        const hamburger = document.getElementById('hamburger');
        const mobileMenu = document.getElementById('mobileMenu');
        
        hamburger.addEventListener('click', () => {
            hamburger.classList.toggle('active');
            mobileMenu.classList.toggle('active');
        });
        
        // Close mobile menu when clicking outside
        document.addEventListener('click', (e) => {
            if (!hamburger.contains(e.target) && !mobileMenu.contains(e.target)) {
                hamburger.classList.remove('active');
                mobileMenu.classList.remove('active');
            }
        });
    </script>
    
    <!-- Page Content Starts Here -->
    <div class="page-content">
