<?php include 'header.php'; ?>

<!-- Hero Section -->
<section class="hero-section relative overflow-hidden py-20 md:py-32">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <!-- Hero Content -->
            <div class="hero-content" style="animation: fadeInLeft 1s ease-out;">
                <div class="inline-block mb-4">
                    <span class="badge">
                        <i class="fas fa-shield-halved mr-2"></i>Offshore DMCA Ignored Hosting
                    </span>
                </div>
                <h1 class="hero-title mb-6">
                    Your Privacy Is <span class="gradient-text">Our Priority</span>
                </h1>
                <p class="hero-description mb-8">
                    Experience true freedom with MaskHosting's offshore hosting solutions. DMCA ignored, maximum privacy protection, and bulletproof reliability. Host your content without fear, censorship, or restrictions.
                </p>
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="pricing.php" class="btn-primary text-center">
                        <i class="fas fa-rocket mr-2"></i>Get Started Now
                    </a>
                    <a href="features.php" class="btn-secondary text-center">
                        <i class="fas fa-list-check mr-2"></i>View Features
                    </a>
                </div>
                
                <!-- Stats -->
                <div class="grid grid-cols-3 gap-6 mt-12">
                    <div class="stat-item">
                        <div class="stat-number">99.9%</div>
                        <div class="stat-label">Uptime</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number">24/7</div>
                        <div class="stat-label">Support</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number">10k+</div>
                        <div class="stat-label">Clients</div>
                    </div>
                </div>
            </div>
            
            <!-- Hero Visual -->
            <div class="hero-visual" style="animation: fadeInRight 1s ease-out;">
                <div class="server-illustration">
                    <div class="server-box">
                        <div class="server-lights">
                            <span class="light active"></span>
                            <span class="light active"></span>
                            <span class="light"></span>
                        </div>
                        <div class="server-content">
                            <i class="fas fa-server text-6xl text-primary mb-4"></i>
                            <div class="pulse-ring"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Domain Search Section -->
<section class="domain-search-section py-16 relative">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="domain-search-box">
            <h2 class="text-3xl md:text-4xl font-bold text-center mb-4">Find Your Perfect Domain</h2>
            <p class="text-center text-gray-400 mb-8">Register your domain with complete privacy protection and instant setup</p>
            
            <form id="domainSearchForm" class="domain-search-form">
                <div class="search-container">
                    <input type="text" id="domainInput" placeholder="Enter your domain name..." class="domain-input" required>
                    <select id="domainExtension" class="domain-extension">
                        <option value=".com">.com</option>
                        <option value=".net">.net</option>
                        <option value=".org">.org</option>
                        <option value=".io">.io</option>
                        <option value=".app">.app</option>
                        <option value=".dev">.dev</option>
                    </select>
                    <button type="submit" class="search-button">
                        <i class="fas fa-search mr-2"></i>Search
                    </button>
                </div>
            </form>
            
            <div class="popular-extensions mt-6 text-center">
                <span class="text-sm text-gray-500 mr-3">Popular:</span>
                <span class="extension-tag">.com - $9.99/yr</span>
                <span class="extension-tag">.net - $11.99/yr</span>
                <span class="extension-tag">.org - $10.99/yr</span>
                <span class="extension-tag">.io - $39.99/yr</span>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="features-section py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Why Choose MaskHosting?</h2>
            <p class="section-description">Unmatched privacy, security, and performance for your offshore hosting needs</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Feature 1 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-shield-check"></i>
                </div>
                <h3 class="feature-title">DMCA Ignored</h3>
                <p class="feature-text">Host your content without worrying about DMCA takedown notices. Our offshore infrastructure ensures your content stays online.</p>
            </div>
            
            <!-- Feature 2 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-user-secret"></i>
                </div>
                <h3 class="feature-title">Complete Privacy</h3>
                <p class="feature-text">Your data is your business. We don't log, we don't track, and we don't share your information with anyone.</p>
            </div>
            
            <!-- Feature 3 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-bolt"></i>
                </div>
                <h3 class="feature-title">Lightning Fast</h3>
                <p class="feature-text">SSD storage, premium bandwidth, and optimized servers ensure your websites load at blazing speeds.</p>
            </div>
            
            <!-- Feature 4 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h3 class="feature-title">24/7 Support</h3>
                <p class="feature-text">Expert support team available around the clock via ticket, email, and live chat to assist you.</p>
            </div>
            
            <!-- Feature 5 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-infinity"></i>
                </div>
                <h3 class="feature-title">Unlimited Bandwidth</h3>
                <p class="feature-text">No traffic limits. No throttling. Serve unlimited visitors without worrying about bandwidth caps.</p>
            </div>
            
            <!-- Feature 6 -->
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-lock"></i>
                </div>
                <h3 class="feature-title">Free SSL Certificate</h3>
                <p class="feature-text">Every hosting plan includes free SSL certificates to keep your websites secure and boost SEO rankings.</p>
            </div>
        </div>
    </div>
</section>

<!-- Services Overview Section -->
<section class="services-overview py-20 relative">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Our Hosting Solutions</h2>
            <p class="section-description">Choose the perfect hosting plan for your needs</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Shared Hosting -->
            <div class="service-card">
                <div class="service-icon-large">
                    <i class="fas fa-hard-drive"></i>
                </div>
                <h3 class="service-card-title">Shared Hosting</h3>
                <p class="service-card-description">Perfect for websites, blogs, and small businesses. Affordable offshore hosting with DMCA ignored policies.</p>
                <ul class="service-features">
                    <li><i class="fas fa-check text-primary mr-2"></i>Unlimited Bandwidth</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>Free SSL Certificates</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>cPanel Control Panel</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>99.9% Uptime Guarantee</li>
                </ul>
                <div class="service-price">
                    <span class="price-amount">$4.99</span>
                    <span class="price-period">/month</span>
                </div>
                <a href="shared-hosting.php" class="btn-primary w-full text-center mt-6">Learn More</a>
            </div>
            
            <!-- VPS Hosting -->
            <div class="service-card featured">
                <div class="featured-badge">Most Popular</div>
                <div class="service-icon-large">
                    <i class="fas fa-server"></i>
                </div>
                <h3 class="service-card-title">VPS Hosting</h3>
                <p class="service-card-description">Powerful virtual private servers with full root access. Scalable resources for growing projects.</p>
                <ul class="service-features">
                    <li><i class="fas fa-check text-primary mr-2"></i>Full Root Access</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>Dedicated Resources</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>Multiple OS Options</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>Instant Deployment</li>
                </ul>
                <div class="service-price">
                    <span class="price-amount">$19.99</span>
                    <span class="price-period">/month</span>
                </div>
                <a href="vps-hosting.php" class="btn-primary w-full text-center mt-6">Learn More</a>
            </div>
            
            <!-- Cloud Hosting -->
            <div class="service-card">
                <div class="service-icon-large">
                    <i class="fas fa-cloud"></i>
                </div>
                <h3 class="service-card-title">Cloud Hosting</h3>
                <p class="service-card-description">Enterprise-grade cloud infrastructure with automatic scaling and maximum reliability.</p>
                <ul class="service-features">
                    <li><i class="fas fa-check text-primary mr-2"></i>Auto-Scaling Resources</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>Load Balancing</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>99.99% Uptime SLA</li>
                    <li><i class="fas fa-check text-primary mr-2"></i>Global CDN Included</li>
                </ul>
                <div class="service-price">
                    <span class="price-amount">$29.99</span>
                    <span class="price-period">/month</span>
                </div>
                <a href="vps-hosting.php" class="btn-primary w-full text-center mt-6">Learn More</a>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="testimonials-section py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">What Our Clients Say</h2>
            <p class="section-description">Join thousands of satisfied customers who trust MaskHosting</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Testimonial 1 -->
            <div class="testimonial-card">
                <div class="stars mb-4">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-text">"MaskHosting has been a game-changer for our business. True privacy and zero interference. Their support team is incredibly responsive and knowledgeable."</p>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div>
                        <div class="author-name">Alex Thompson</div>
                        <div class="author-role">CEO, TechStart Inc</div>
                    </div>
                </div>
            </div>
            
            <!-- Testimonial 2 -->
            <div class="testimonial-card">
                <div class="stars mb-4">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-text">"I've tried many offshore hosting providers, but MaskHosting stands out. Excellent uptime, fast servers, and they truly respect privacy. Highly recommended!"</p>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div>
                        <div class="author-name">Sarah Martinez</div>
                        <div class="author-role">Blogger & Content Creator</div>
                    </div>
                </div>
            </div>
            
            <!-- Testimonial 3 -->
            <div class="testimonial-card">
                <div class="stars mb-4">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-text">"The VPS hosting is phenomenal. Full control, amazing performance, and the peace of mind that comes with offshore hosting. MaskHosting delivers on all promises."</p>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div>
                        <div class="author-name">Michael Chen</div>
                        <div class="author-role">Developer & Entrepreneur</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Trust & Security Section -->
<section class="trust-section py-20 relative">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="section-title text-left">Built on Trust & Security</h2>
                <p class="text-gray-400 text-lg mb-8">At MaskHosting, we understand that your privacy and security are paramount. That's why we've built our entire infrastructure around these core principles.</p>
                
                <div class="space-y-6">
                    <div class="trust-item">
                        <div class="trust-item-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <div>
                            <h3 class="trust-item-title">Offshore Infrastructure</h3>
                            <p class="trust-item-text">Our servers are strategically located in privacy-friendly jurisdictions, ensuring maximum protection from invasive regulations.</p>
                        </div>
                    </div>
                    
                    <div class="trust-item">
                        <div class="trust-item-icon">
                            <i class="fas fa-database"></i>
                        </div>
                        <div>
                            <h3 class="trust-item-title">No Data Retention</h3>
                            <p class="trust-item-text">We maintain a strict no-logs policy. Your data, your business. We don't store what we don't need.</p>
                        </div>
                    </div>
                    
                    <div class="trust-item">
                        <div class="trust-item-icon">
                            <i class="fas fa-certificate"></i>
                        </div>
                        <div>
                            <h3 class="trust-item-title">Enterprise Security</h3>
                            <p class="trust-item-text">DDoS protection, advanced firewalls, and regular security audits keep your assets safe 24/7.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="security-visual">
                <div class="security-shield">
                    <i class="fas fa-shield-halved text-9xl text-primary opacity-20"></i>
                    <div class="security-rings">
                        <div class="ring ring-1"></div>
                        <div class="ring ring-2"></div>
                        <div class="ring ring-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section py-20">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">Ready to Experience True Freedom?</h2>
        <p class="text-xl text-gray-400 mb-10">Join thousands of customers who've already made the switch to MaskHosting. Your privacy journey starts here.</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="pricing.php" class="btn-primary text-lg px-10 py-4">
                <i class="fas fa-rocket mr-2"></i>Get Started Today
            </a>
            <a href="contact.php" class="btn-secondary text-lg px-10 py-4">
                <i class="fas fa-comments mr-2"></i>Talk to Sales
            </a>
        </div>
    </div>
</section>

<style>
    /* Hero Section */
    .hero-section {
        min-height: 80vh;
        display: flex;
        align-items: center;
    }
    
    .badge {
        display: inline-flex;
        align-items: center;
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid rgba(0, 255, 136, 0.3);
        color: var(--primary);
        padding: 8px 20px;
        border-radius: 50px;
        font-size: 0.9rem;
        font-weight: 600;
        letter-spacing: 0.5px;
    }
    
    .hero-title {
        font-family: 'Orbitron', monospace;
        font-size: 3rem;
        font-weight: 900;
        line-height: 1.2;
        color: white;
    }
    
    .gradient-text {
        background: linear-gradient(135deg, var(--primary), #00ccff);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .hero-description {
        font-size: 1.2rem;
        color: #9ca3af;
        line-height: 1.8;
    }
    
    .stat-item {
        text-align: center;
    }
    
    .stat-number {
        font-family: 'Orbitron', monospace;
        font-size: 2rem;
        font-weight: 900;
        color: var(--primary);
        margin-bottom: 0.5rem;
    }
    
    .stat-label {
        font-size: 0.9rem;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    /* Server Illustration */
    .server-illustration {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
    }
    
    .server-box {
        background: linear-gradient(135deg, rgba(0, 255, 136, 0.1), rgba(0, 204, 255, 0.1));
        border: 2px solid rgba(0, 255, 136, 0.3);
        border-radius: 20px;
        padding: 3rem;
        position: relative;
        overflow: hidden;
    }
    
    .server-box::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: conic-gradient(from 0deg, transparent, var(--primary), transparent);
        animation: rotate 4s linear infinite;
        opacity: 0.1;
    }
    
    @keyframes rotate {
        100% { transform: rotate(360deg); }
    }
    
    .server-lights {
        display: flex;
        gap: 10px;
        margin-bottom: 2rem;
    }
    
    .light {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background: #374151;
    }
    
    .light.active {
        background: var(--primary);
        box-shadow: 0 0 10px var(--primary);
        animation: blink 2s ease-in-out infinite;
    }
    
    @keyframes blink {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.3; }
    }
    
    .server-content {
        text-align: center;
        position: relative;
        z-index: 1;
    }
    
    .pulse-ring {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        width: 150px;
        height: 150px;
        border: 3px solid var(--primary);
        border-radius: 50%;
        animation: pulse 2s ease-out infinite;
    }
    
    @keyframes pulse {
        0% {
            transform: translate(-50%, -50%) scale(0.8);
            opacity: 1;
        }
        100% {
            transform: translate(-50%, -50%) scale(1.5);
            opacity: 0;
        }
    }
    
    /* Domain Search */
    .domain-search-section {
        background: rgba(10, 14, 39, 0.5);
        backdrop-filter: blur(10px);
    }
    
    .domain-search-box {
        background: rgba(15, 22, 41, 0.8);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 3rem;
    }
    
    .search-container {
        display: flex;
        flex-wrap: wrap;
        gap: 1rem;
        background: var(--dark);
        border: 2px solid rgba(0, 255, 136, 0.3);
        border-radius: 12px;
        padding: 0.5rem;
    }
    
    .domain-input {
        flex: 1;
        min-width: 200px;
        background: transparent;
        border: none;
        color: white;
        font-size: 1.1rem;
        padding: 1rem;
        outline: none;
    }
    
    .domain-extension {
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid rgba(0, 255, 136, 0.3);
        border-radius: 8px;
        color: white;
        padding: 0 1.5rem;
        font-size: 1rem;
        font-weight: 600;
        outline: none;
        cursor: pointer;
    }
    
    .search-button {
        background: var(--primary);
        color: var(--dark);
        border: none;
        border-radius: 8px;
        padding: 1rem 2rem;
        font-weight: 700;
        font-size: 1rem;
        cursor: pointer;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .search-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 30px rgba(0, 255, 136, 0.4);
    }
    
    .extension-tag {
        display: inline-block;
        background: rgba(0, 255, 136, 0.1);
        border: 1px solid rgba(0, 255, 136, 0.2);
        color: var(--primary);
        padding: 6px 12px;
        border-radius: 6px;
        margin: 0 0.25rem;
        font-size: 0.85rem;
        font-weight: 600;
    }
    
    /* Section Styles */
    .section-title {
        font-family: 'Orbitron', monospace;
        font-size: 2.5rem;
        font-weight: 900;
        margin-bottom: 1rem;
        background: linear-gradient(135deg, white, var(--primary));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .section-description {
        font-size: 1.2rem;
        color: #9ca3af;
        max-width: 600px;
        margin: 0 auto;
    }
    
    /* Feature Cards */
    .feature-card {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 16px;
        padding: 2rem;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .feature-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(0, 255, 136, 0.1), transparent);
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .feature-card:hover {
        transform: translateY(-10px);
        border-color: var(--primary);
        box-shadow: 0 20px 40px rgba(0, 255, 136, 0.2);
    }
    
    .feature-card:hover::before {
        opacity: 1;
    }
    
    .feature-icon {
        width: 70px;
        height: 70px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        color: var(--primary);
        margin-bottom: 1.5rem;
        transition: all 0.3s ease;
    }
    
    .feature-card:hover .feature-icon {
        transform: scale(1.1) rotate(5deg);
        box-shadow: 0 10px 30px rgba(0, 255, 136, 0.3);
    }
    
    .feature-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        color: white;
    }
    
    .feature-text {
        color: #9ca3af;
        line-height: 1.8;
    }
    
    /* Service Cards */
    .service-card {
        background: rgba(15, 22, 41, 0.8);
        border: 2px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 2.5rem;
        transition: all 0.3s ease;
        position: relative;
    }
    
    .service-card.featured {
        border-color: var(--primary);
        box-shadow: 0 0 40px rgba(0, 255, 136, 0.3);
        transform: scale(1.05);
    }
    
    .featured-badge {
        position: absolute;
        top: -15px;
        right: 20px;
        background: var(--primary);
        color: var(--dark);
        padding: 8px 20px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .service-card:hover {
        transform: translateY(-10px);
        border-color: var(--primary);
        box-shadow: 0 20px 50px rgba(0, 255, 136, 0.3);
    }
    
    .service-icon-large {
        width: 80px;
        height: 80px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2.5rem;
        color: var(--primary);
        margin: 0 auto 2rem;
    }
    
    .service-card-title {
        font-size: 1.8rem;
        font-weight: 700;
        text-align: center;
        margin-bottom: 1rem;
    }
    
    .service-card-description {
        text-align: center;
        color: #9ca3af;
        margin-bottom: 2rem;
        line-height: 1.8;
    }
    
    .service-features {
        list-style: none;
        margin-bottom: 2rem;
    }
    
    .service-features li {
        padding: 0.75rem 0;
        color: #d1d5db;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .service-price {
        text-align: center;
        margin: 2rem 0;
    }
    
    .price-amount {
        font-family: 'Orbitron', monospace;
        font-size: 3rem;
        font-weight: 900;
        color: var(--primary);
    }
    
    .price-period {
        color: #6b7280;
        font-size: 1.2rem;
        margin-left: 0.5rem;
    }
    
    /* Testimonial Cards */
    .testimonial-card {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 16px;
        padding: 2rem;
        transition: all 0.3s ease;
    }
    
    .testimonial-card:hover {
        transform: translateY(-5px);
        border-color: var(--primary);
        box-shadow: 0 15px 35px rgba(0, 255, 136, 0.2);
    }
    
    .stars {
        color: #fbbf24;
        font-size: 1.2rem;
    }
    
    .testimonial-text {
        color: #d1d5db;
        line-height: 1.8;
        margin-bottom: 1.5rem;
        font-style: italic;
    }
    
    .testimonial-author {
        display: flex;
        align-items: center;
        gap: 1rem;
    }
    
    .author-avatar {
        width: 50px;
        height: 50px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary);
        font-size: 1.5rem;
    }
    
    .author-name {
        font-weight: 700;
        color: white;
    }
    
    .author-role {
        font-size: 0.9rem;
        color: #6b7280;
    }
    
    /* Trust Section */
    .trust-item {
        display: flex;
        gap: 1.5rem;
        align-items: start;
    }
    
    .trust-item-icon {
        width: 60px;
        height: 60px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.8rem;
        color: var(--primary);
        flex-shrink: 0;
    }
    
    .trust-item-title {
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    
    .trust-item-text {
        color: #9ca3af;
        line-height: 1.7;
    }
    
    .security-visual {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
        height: 400px;
    }
    
    .security-shield {
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    
    .security-rings {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }
    
    .ring {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        border: 2px solid var(--primary);
        border-radius: 50%;
        opacity: 0.3;
    }
    
    .ring-1 {
        width: 200px;
        height: 200px;
        animation: ringPulse 3s ease-in-out infinite;
    }
    
    .ring-2 {
        width: 300px;
        height: 300px;
        animation: ringPulse 3s ease-in-out infinite 0.5s;
    }
    
    .ring-3 {
        width: 400px;
        height: 400px;
        animation: ringPulse 3s ease-in-out infinite 1s;
    }
    
    @keyframes ringPulse {
        0%, 100% {
            transform: translate(-50%, -50%) scale(1);
            opacity: 0.3;
        }
        50% {
            transform: translate(-50%, -50%) scale(1.1);
            opacity: 0.1;
        }
    }
    
    /* CTA Section */
    .cta-section {
        background: linear-gradient(135deg, rgba(0, 255, 136, 0.1), rgba(0, 204, 255, 0.1));
        border-top: 1px solid rgba(0, 255, 136, 0.3);
        border-bottom: 1px solid rgba(0, 255, 136, 0.3);
    }
    
    /* Animations */
    @keyframes fadeInLeft {
        from {
            opacity: 0;
            transform: translateX(-50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }
    
    @keyframes fadeInRight {
        from {
            opacity: 0;
            transform: translateX(50px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }
    
    @media (max-width: 768px) {
        .hero-title {
            font-size: 2rem;
        }
        
        .section-title {
            font-size: 2rem;
        }
        
        .search-container {
            flex-direction: column;
        }
        
        .domain-input,
        .domain-extension,
        .search-button {
            width: 100%;
        }
    }
</style>

<script>
    // Domain Search Form
    document.getElementById('domainSearchForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const domain = document.getElementById('domainInput').value.trim();
        const extension = document.getElementById('domainExtension').value;
        
        if (domain) {
            const fullDomain = domain.replace(/\.[a-z]+$/i, '') + extension;
            // Redirect to client area with domain search
            window.location.href = '<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&domain=register&query=' + encodeURIComponent(fullDomain);
        }
    });
</script>

<?php include 'footer.php'; ?>
